function tracknucSingleClick2
%% help
% comments
%% Parameters for positions and colors of figures and some handles
% The position of the game figure will be [figX1,figX2,figY1,figY2]
figX1 = 0;
figX2 = 1020;
figY1 = 0;
figY2 = 1020;
%% sets initial variables
FileName = '';
PathName = '';
FilterIndex = '';
frame = 1;
frameinit = 1;
framefin = 150;
Nf = 150;
Img = [];
center.x = 512;
center.y = 512;
radius = 100;
boo = [];
%% Create and hide the GUI figure as it is being constructed.
segfigure = figure('Visible','on','Tag','segfigure','Position',[figX1,figY1,figX2,figY2]);
set ( gcf, 'Color', [0 0 0] )

% To capture mouse and keyboard
set(segfigure,'WindowKeyPressFcn',@keypress);
set(segfigure,'WindowScrollWheelFcn',@scroll);
set(segfigure,'WindowButtonUpFcn',@click);
%% Create buttons and others
hmessages = uicontrol('Style','text','String','Please load a movie',...
    'Position',[50,950,350,50],'FontSize',14, ...
    'ForegroundColor','white','BackgroundColor','black'); % Display instructions

hquitbutton = uicontrol('Style','pushbutton',...
    'String','Quit','Callback',@hquitbutton_Callback,...
    'Position',[950,950,50,50]); % Quit seg
%20.6628 -446.1809  144.5822   52.1283

hmod = uicontrol('Style','pushbutton',...
    'String','Modify','Callback',@hmod_Callback,...
    'Position',[950,850,50,50]); % Quit seg

hloadbutton = uicontrol('Style','pushbutton',...
    'String','Load','Callback',@hloadbutton_Callback,...
    'Position',[400,950,100,50]); % load file

hpath = uicontrol('Style','text','String','Path',...
    'Position',[510,950,400,50],'FontSize',10);

hframe = uicontrol('Style','slider',...
    'Min',1,'Max',Nf, 'value',frame,...
    'Position',[20,10,950,20],...
    'SliderStep',[1/150 0.2],'Callback',@hframe_Callback);

hsave = uicontrol('Style','pushbutton','String', 'Save ROIs',...
    'Position',[10,950,100,50],...
    'Callback',@hsave_Callback);
%% Create axes and display image
canvas = 870;
ImgOp = imread('cell.tif',1);
sI = size(ImgOp);
panelI_X1 = 40;
%panelI_X2 = panelI_X1+sI(2);
panelI_X2 = canvas;
panelI_Y1 = 40;
%panelI_Y2 = panelI_Y1+sI(1);
panelI_Y2 = canvas;
ha = axes('Units','Pixels','Position',[panelI_X1,panelI_Y1,panelI_X2,panelI_Y2]);
imshow(ImgOp,[]);
% Change units to normalized so components resize automatically.
set([segfigure,ha,hmessages...
    hpath,hloadbutton,hquitbutton,...
    hframe,hsave,hmod],...
    'Units','normalized');
%% Final settings
% Assign the GUI a name to appear in the window title.
set(segfigure,'Name','Segment NUP V1')
% Move the GUI to the center of the screen.
movegui(segfigure,'north')
% Make the GUI visible.
set(segfigure,'Visible','on')

%% Callbacks
    function keypress(~,~)
        % Not used...
    end
    function click(~,~)
        % Not used...
    end
    function hquitbutton_Callback(~,~)
        close(segfigure);
    end

    function hloadbutton_Callback(~,~)
        frame = 1;
        set(hframe,'Value',frame);
        [FileName,PathName,FilterIndex] = uigetfile('*.tif','Select the tif file');
        set(hpath,'String',[PathName,FileName]);
        info = imfinfo([PathName,FileName]);
        Nf = length(info);
        center.x = 512*ones(Nf,1);
        center.y = 512*ones(Nf,1);
        boo = zeros(Nf,1);
        Wd = info(1).Width;
        Hg = info(1).Height;
        sI = [Hg,Wd];
        Img = [];
        for i=1:Nf
            Img = cat(3,Img,imread([PathName,FileName],i));
        end
        showI
        %showI(Img(:,:,1),lines);
        set(hframe,'max',Nf,'SliderStep',[1/(Nf-1) 0.4])
        set(hmessages,'String',['Loaded. Frame ',num2str(frame)]);
        %hl(1) = imline(gca,xx1(1,:), yy1(1,:));
        %hl(2) = imline(gca,xx2(1,:), yy2(1,:));
    end

    function hframe_Callback(~,~)
        frame = get(hframe,'Value');
        frame = round(frame);
        set(hframe,'Value',frame);
        showI
        set(hmessages,'String',['Frame ',num2str(frame)]);
    end

    function scroll(src,evnt)
        deltaframe = evnt.VerticalScrollCount;
        frame = frame + deltaframe;
        if frame<1
            frame=1;
        end
        if frame>Nf
            frame = Nf;
        end
        set(hframe,'Value',frame);
        showI
        set(hmessages,'String',['Frame ',num2str(frame)]);
    end

    function hmod_Callback(~,~)
            [xi,yi]=ginput(1);
            imshow(Img(:,:,frame),[]);
            hold on
            plot(xi,yi,'oc','markersize',6,'markerfacecolor','c');
            center.x(frame) = xi;
            center.y(frame) = yi;
    end

    function hsave_Callback(~,~)
        k = strfind(FileName,'.');
        save([PathName,FileName(1:k-1),'_nucSC.mat'],'center');
    end
%% Functions
    function showI
        axes(ha);
        imshow(Img(:,:,frame),[]);
        hold on
        
        if boo(frame)==0
            [xi,yi]=ginput(1);
            plot(xi,yi,'oc','markersize',6,'markerfacecolor','c');
            center.x(frame) = xi;
            center.y(frame) = yi;
            boo(frame)=1;
        else
            plot(center.x(frame),center.y(frame),'oc','markersize',6,'markerfacecolor','c');
        end
    end
end